<?php

@error_reporting ( E_ALL ^ E_WARNING ^ E_NOTICE );
@ini_set ( 'display_errors', true );
@ini_set ( 'html_errors', false );
@ini_set ( 'error_reporting', E_ALL ^ E_WARNING ^ E_NOTICE );

define( 'DATALIFEENGINE', true );
define( 'ROOT_DIR', '.' );
define( 'ENGINE_DIR', './engine' );

require_once ENGINE_DIR . '/data/config.php';
require_once ENGINE_DIR . '/classes/mysql.php';
require_once ENGINE_DIR . '/data/dbconfig.php';

header("Content-type: text/html; charset={$config['charset']}");

$title = " UserStatus V2.0";

$US_files = array();
$US_files[] = array("");
$US_files[] = array("user-status.php");
$US_files[] = array("ajax.php");
$US_files[] = array("config.php");
$US_files[] = array("SimpleCache.php");
$US_files[] = array("cache");
$US_files[] = array("images");

$fatal_error = false;
$warning = false;

$filesCheck = "";

foreach ($US_files as $file) {
    $server_path = ROOT_DIR . "/engine/modules/users_status/" . $file[0];

    if(file_exists($server_path)) {
        $result = '<span class="ok"></span>';
        if((! is_writable($server_path)) and $file[1]){
            $warning = true;
            $file_exists = '<span class="error">  </span>';
        }
    } else {
        $fatal_error = true;
        $result = '<span class="error"></span>';
    }

    $filesCheck .= "engine/modules/users_status/{$file[0]}  {$result}<br />";
}

if(empty($_POST['submit']) === false){
    $db->query("CREATE TABLE IF NOT EXISTS `" . USERPREFIX . "_users_status` (`id` int(11) unsigned NOT NULL AUTO_INCREMENT, `name` varchar(255) NOT NULL,   `user_status` text NOT NULL, `status_timestamp` varchar(32) NOT NULL, PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=cp1251 AUTO_INCREMENT=1 ;");
$installer = <<<HTML
    <div class="installer">
    <p>!   .<br />
    <b>    UserStatusInstaller.php!</b><br /><br /></p>
    </div>
HTML;
}else{
    if($warning === false && $fatal_error === false){
$installer = <<<HTML
	{$filesCheck}
    <div class="installer">
    <p>   .<br />
	  ,   " ".<br /></p>
	<input value=' ' type='submit' id="installerButton" name="submit" />
    </div>
HTML;
    }else{
$installer = <<<HTML
    <div class="installer">
    <p class="error">     .</p>
    </div>
HTML;
    }
}

?>
<!DOCTYPE html>
<html>
<head>
    <title><?=$title?></title>
    <link href='http://fonts.googleapis.com/css?family=Open+Sans&subset=cyrillic,latin' rel='stylesheet' type='text/css'>
</head>
<style>
    html, body, div, span, applet, object, iframe,
    h1, h2, h3, h4, h5, h6, p, blockquote, pre,
    a, abbr, acronym, address, big, cite, code,
    del, dfn, em, img, ins, kbd, q, s, samp,
    small, strike, strong, sub, sup, tt, var,
    b, u, i, center,
    dl, dt, dd, ol, ul, li,
    fieldset, form, label, legend,
    table, caption, tbody, tfoot, thead, tr, th, td,
    article, aside, canvas, details, embed,
    figure, figcaption, footer, header, hgroup,
    menu, nav, output, ruby, section, summary,
    time, mark, audio, video {
        margin: 0;
        padding: 0;
        border: 0;
        font-size: 100%;
        font: inherit;
        vertical-align: baseline;
    }
        /* HTML5 display-role reset for older browsers */
    article, aside, details, figcaption, figure,
    footer, header, hgroup, menu, nav, section {
        display: block;
    }
    body {
        line-height: 1;
        font-family: 'Open Sans', sans-serif;
    }
    ol, ul {
        list-style: none;
    }
    blockquote, q {
        quotes: none;
    }
    blockquote:before, blockquote:after,
    q:before, q:after {
        content: '';
        content: none;
    }
    table {
        border-collapse: collapse;
        border-spacing: 0;
    }
    header{
        background: #1D8CC6;
        padding: 15px;
        font-size: 20px;
        color: #D0E2EC;
    }
    body{
        background: #DBE1E4;
    }
    .installerBox{
        font-size: 14px;
        width: 550px;
        margin: 150px auto 0 auto;
        background: #EBF3F8;
        padding: 15px;
        -moz-box-shadow: 0px 2px 5px 1px #cdd4d8;
        -webkit-box-shadow: 0px 2px 5px 1px #cdd4d8;
        box-shadow: 0px 2px 5px 1px #cdd4d8;
        filter: progid:DXImageTransform.Microsoft.Shadow(strength = 2, direction = 180, color = '#cdd4d8');
        -ms-filter: "progid:DXImageTransform.Microsoft.Shadow(strength = 2, Direction = 180, Color = '#cdd4d8')";
    }
    h2{
        font-size: 17px;
        margin: -15px -15px 15px;
        padding: 15px;
        background: #313436;
        color: #CCCCCC;
        text-align: center;
    }
    .ok{
        color: #6CBD23;
    }
    .error{
        color: #E14546;
    }
    input{
        background: #6BB5F5;
        border: none;
        color: white;
        padding: 10px 23px;
        font-size: 15px;
        margin: 15px 0 0 182px;
        cursor: pointer;
    }
    input:hover{
        background: #72B0E5;
        -webkit-transition: all 0.5s ease;
        -moz-transition: all 0.5s ease;
        -o-transition: all 0.5s ease;
    }
    .installer p{
        text-align: center;
        margin-top: 10px;
    }
    b{
        font-weight: bold;
    }
</style>
<body>

    <header>
        <h1>  V2.0</h1>
    </header>
    <div class="installerBox">
        <h2><?=$title?></h2>
        <form method="post" action="">
            <?=$installer?>
        </form>
    </div>

</body>
</html>